/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.test;

import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSPart;
import filenet.ws.listener.axis.AxisFactorySettings;
import filenet.ws.listener.axis.SOAPMessageUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;

public class WSMessageTest {
    private static final String m_className = "WSMessageTest";
    protected static final Logger logger = Logger.getLogger("filenet.ws.api");
    private WSDefinition m_definition = null;
    private String m_portType;
    private String m_op;
    private String m_endPoint;
    private String m_inputMsgName;
    private String m_outputMsgName;
    private String[] m_rpcOutMsgParts;
    private String[] m_rpcOutAccessors;

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:47:26  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }

    public WSMessageTest(String wsdlFile, String portType, String op, String inputMsgName, String outputMsgName) throws Exception {
        String m_method = "ctor:" + wsdlFile;
        this.m_endPoint = wsdlFile;
        this.m_portType = portType;
        this.m_op = op;
        this.m_inputMsgName = inputMsgName;
        this.m_outputMsgName = outputMsgName;
        try {
            this.m_definition = new WSDefinition(this.m_endPoint);
        }
        catch (Exception we) {
            logger.throwing(m_className, m_method, we);
            throw we;
        }
    }

    public void testDTS171242(String outMsgFileName) throws Exception {
        String m_method = "testDTS171242";
        WSMessage SOAPOutMsg = this.m_definition.getOperation(this.m_portType, this.m_op, this.m_inputMsgName, this.m_outputMsgName).getOutMessage();
        if (SOAPOutMsg != null) {
            int nParts;
            WSPart[] parts = SOAPOutMsg.getParts();
            int n = nParts = parts == null ? 0 : parts.length;
            if (nParts > 0) {
                this.m_rpcOutMsgParts = new String[nParts];
                this.m_rpcOutAccessors = new String[nParts];
                for (int i = 0; i < nParts; ++i) {
                    this.m_rpcOutMsgParts[i] = parts[i].getPart().getName();
                    this.m_rpcOutAccessors[i] = this.m_op + this.m_rpcOutMsgParts[i];
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, "testDTS171242", "RPC accessors = " + Logger.asString(this.m_rpcOutAccessors));
                    logger.finest(m_className, "testDTS171242", "RPC out parts = " + Logger.asString(this.m_rpcOutMsgParts));
                }
            }
        }
        String response = WSMessageTest.getFileContents(outMsgFileName);
        SOAPConnectionFactory scFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = scFactory.createConnection();
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(response.getBytes("UTF-8")));
        String newMsg = SOAPMessageUtils.getRPCBodyChildElementsAsString(message.getSOAPPart().getEnvelope().getBody(), this.m_rpcOutAccessors, this.m_rpcOutMsgParts);
        System.out.println("OLD MESSAGE=");
        System.out.println(response);
        System.out.println("NEW MESSAGE=");
        System.out.println(newMsg);
    }

    private static String getFileContents(String fileName) throws Exception {
        File f = new File(fileName);
        if (!f.exists()) {
            System.err.println(fileName + " does not exist!");
            throw new FileNotFoundException(fileName);
        }
        FileInputStream inStream = new FileInputStream(f);
        int size = inStream.available();
        byte[] b = new byte[size];
        inStream.read(b);
        String res = new String(b);
        return res;
    }

    public static void printUsage() {
        System.out.println("/wsdlFile=wsdlFile /portType=portType /op=op /inputMsgName=inputMsgName /outputMsgName=outputMsgName /outMsgFileName=messageFileName");
        System.exit(1);
    }

    public static void main(String[] args) {
        AxisFactorySettings soapFactorySettings = new AxisFactorySettings();
        try {
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            String wsdlFile = c.getParameter("wsdlFile");
            String portType = c.getParameter("portType");
            String op = c.getParameter("op");
            String inputMsgName = c.getParameter("inputMsgName");
            String outputMsgName = c.getParameter("outputMsgName");
            String outMsgFileName = c.getParameter("outMsgFileName");
            if (wsdlFile == null || portType == null || op == null || outMsgFileName == null) {
                WSMessageTest.printUsage();
            }
            WSMessageTest test = new WSMessageTest(wsdlFile, portType, op, inputMsgName, outputMsgName);
            test.testDTS171242(outMsgFileName);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

